package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * NDS workflow:  intermediate review groups
 */
@Entity
@Table(name="reviewtemplate", schema="hib")
public class ReviewTemplate extends ReferenceObject {

	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="groupid")
	Group reviewer;

	@Column(name="active", columnDefinition = "BIT", length = 1)
	private Boolean active;
	
	
	public Group getReviewer() {
		return reviewer;
	}
	
	public void setReviewer(final Group reviewer) {
		this.reviewer = reviewer;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}
	
	
	public static ReviewTemplate findById(int reviewTemplateId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getReviewTemplateDAO().findById(reviewTemplateId);
	}
	
	public static ReviewTemplate findByGroupId(int groupId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getReviewTemplateDAO().findByGroupId(groupId);
	}
	
	public static List<ReviewTemplate> listAll() {
		return DartObjectFactory.getInstance().getReviewTemplateDAO().listAll();
	}
	
	public static List<ReviewTemplate> listAllActive() {
		return DartObjectFactory.getInstance().getReviewTemplateDAO().listAllActive();
	}
}
